-- LightCreationTool Script
-- Created:       Jan 18 2005
-- Last Modified: Mar 18 2005
-- Version: VIZ 2006
-- Author: Alexander Esppeschit Bicalho, Discreet
--***********************************************************************************************
-- MODIFY THIS AT YOUR OWN RISK

/*

This file is intended to use with the creation tools available in the tool palette.

Usage is inside a macroscript. The macro will have to create a light and hand it to the tool for positioning.

Example Macros:

macroScript Free_40W_Bulb_ZBased
            category:~FREE_40W_BULB_ZBASED_LIGHTS_CAMERA_CAPTION~
            internalcategory:"Lights and Cameras"
			ButtonText:~40W_BULB_ZBASED_BUTTON_CAPTION~
            tooltip:~40W_BULB_ZBASED_TOOLTIP~ 
            icon:#("PhotometricLights",3)
            --palettehint: Incandescent --used for publishing to palettes
(
	-- sets properties of newly created linear lights based on the newNodeCallback callback
	 fn setprops n =
	 (
	 	if isKindof n Light do -- pfb march 4 2003: make sure it only happens on lights.  the callback can also pass the target if the user click "targeted" while creating the light
		(
		 	n.useKelvin = off --forces to use the color dropdown
		 	n.rgb = color 255 244.214 214.62  --sets the 'incandescent' color
			n.distribution = 0 -- sets to a isotropic distribution
			n.intensityType = 1 --sets to be in cd
			n.Intensity = 38
			n.useMultiplier = on
		)

	 )
     on execute do 
	 (
	 	LightHeight = 20
		SetCommandPanelTaskMode #create
		LightCreationTool.isCreatingLight = #Free_40W_Bulb_ZBased
		LightCreationZHeight free_point LightHeight setProps lightName:#Free_40W_Bulb
	 )
     on isChecked return LightCreationTool.isCreatingLight == #Free_40W_Bulb_ZBased
)

macroScript Target_40W_Bulb
            category:~CATEGORY_LIGHTS_CAMERAS_CAPTION~
            internalcategory:"Lights and Cameras"
			ButtonText:~BUTTON_40W_BULB_TARGETED_CAPTION~
            tooltip:~40W_BULB_TARGETED_TOOLTIP~ 
            icon:#("PhotometricLights",3)
            --palettehint: Incandescent --used for publishing to palettes
(
	-- sets properties of newly created linear lights based on the newNodeCallback callback
	 fn setprops n =
	 (
	 	if isKindof n Light do -- pfb march 4 2003: make sure it only happens on lights.  the callback can also pass the target if the user click "targeted" while creating the light
		(
		 	n.useKelvin = off --forces to use the color dropdown
		 	n.rgb = color 255 244.214 214.62  --sets the 'incandescent' color
			n.distribution = 0 -- sets to a isotropic distribution
			n.intensityType = 1 --sets to be in cd
			n.Intensity = 38
			n.useMultiplier = on
		)

	 )
     on execute do 
	 (
	 	LightHeight = 20
		SetCommandPanelTaskMode #create
		LightCreationTool.isCreatingLight = #Target_40W_Bulb
		LightCreationZHeight target_point LightHeight setProps isTargeted:true LightName:#Target_40W_Bulb
	 )
     on isChecked return LightCreationTool.isCreatingLight == #Target_40W_Bulb
)

*/



struct lightCreationToolStr (lightObj, 
							lightHeight, 
							lightClass,
							lightPropfn,
							isTargeted = false,
							isCreatingLight = false)

global LightCreationTool = lightCreationToolStr()

fn LightCreationZHeight lightClass lightHeight lightPropfn isTargeted:false LightName:undefined =
(

-- Setup parameters in the Struct
-- The Tool cannot take local parameters, it needs to grab them from the struct

	lightCreationTool.lightClass = lightClass
	lightCreationTool.lightPropfn = lightPropfn
	lightCreationTool.isTargeted = isTargeted
	LightCreationTool.lightHeight = if lightHeight == undefined then 0 else lightHeight

	tool LiftedLightTool
	(
		on mousePoint clickNo do 
		(
			if clickNo == 1 do -- 1st Click position the light
			(
				local pt = gridPoint
				if lightCreationTool.isTargeted == false then -- Free light
				(
					if snapmode.active == true and snapMode.type == #3D then -- Snap ON
						in coordsys grid lightCreationTool.lightObj = LightCreationTool.LightClass pos:pt
					else -- Snap Off, lift Z
						in coordsys grid lightCreationTool.lightObj = LightCreationTool.LightClass pos:[pt.x, pt.y, lightCreationTool.Lightheight]
				)
				else -- Target Light
				(
					if snapmode.active == true and snapMode.type == #3D then -- Snap ON
						in coordsys grid lightCreationTool.lightObj = LightCreationTool.LightClass pos:pt \
							target:(targetObject())
					else -- Snap off, lift Z
						in coordsys grid lightCreationTool.lightObj = LightCreationTool.LightClass \
							pos:[pt.x, pt.y, lightCreationTool.Lightheight] target:(targetObject())
				)
				if classof lightCreationTool.lightPropfn == MAXScriptFunction do  -- Apply Properties
					lightCreationTool.lightPropfn lightCreationTool.lightObj
				if isValidNode lightCreationTool.lightObj do
					select lightCreationTool.lightObj
			)
			if clickNo == 2 then -- Release mouse = stop
			(
				#stop
			)
		)--end mousepoint

		on MouseMove clickNo do 
		(
			if (clickNo == 2) do -- Dragging the mouse moves the light (when free) or target (when targeted)
			(
				if isValidNode lightCreationTool.lightObj then
				(
					local st = gridPoint
					if lightCreationTool.isTargeted == false then -- Free Light
					(
						if snapmode.active == true and snapMode.type == #3D then -- Snap On
							in coordsys grid lightCreationTool.lightObj.pos = st
						else -- Snap Off (keep Z up)
							in coordsys grid lightCreationTool.lightObj.pos = [st.x, st.y, lightCreationTool.Lightheight]
					)
					else -- Target Light
					( -- No Snap considerations - it doesn't matter for the target
						in coordsys grid lightCreationTool.lightObj.target.pos = st
					)
				)
				else #abort
			)
		)--end mouse move
	)-- end tool

	-- Start the creation
	local status
	
	if lightClass != undefined and lightClass.creatable do -- if it cannot be created or doesn't exist, bail out
	(
	  local undoName = if lightName == undefined then lightClass.localizedName else lightName as string
	  undo label:undoName on
	  (
		status = starttool LiftedLightTool
		
		-- If it user aborted, delete the light
		if status == #abort then 
			if isValidNode lightCreationTool.lightObj do delete lightCreationTool.lightObj
		else -- ok, user created it, so let's apply the final touch - modify panel, naming, etc
		(
			if isValidNode lightCreationTool.lightObj do
			(
				if lightName != undefined do -- Name the Light based on the name passed to the function
				(
					lightCreationTool.lightObj.name = uniqueName (lightName as string)
					if isTargeted == true do -- if Target Light, name the target too
						lightCreationTool.lightObj.target.name = lightCreationTool.lightObj.name + "." + \
							Targetobject.localizedName
				)
				-- Set Command Panel and select the object
				SetCommandPanelTaskMode #modify
			)
		)
	  ) -- end Undo
	)
	
	--resets the variables and updates the UI
	lightCreationTool.lightObj = undefined
	lightCreationTool.isCreatingLight = false
	updateToolbarButtons()
	
) -- end zHeightLightTool

-------BEGIN-SIGNATURE-----
-- 4wYAADCCBt8GCSqGSIb3DQEHAqCCBtAwggbMAgEBMQ8wDQYJKoZIhvcNAQELBQAw
-- CwYJKoZIhvcNAQcBoIIE3jCCBNowggPCoAMCAQICEDUAFkMQxqI9PltZ2eUG16Ew
-- DQYJKoZIhvcNAQELBQAwgYQxCzAJBgNVBAYTAlVTMR0wGwYDVQQKExRTeW1hbnRl
-- YyBDb3Jwb3JhdGlvbjEfMB0GA1UECxMWU3ltYW50ZWMgVHJ1c3QgTmV0d29yazE1
-- MDMGA1UEAxMsU3ltYW50ZWMgQ2xhc3MgMyBTSEEyNTYgQ29kZSBTaWduaW5nIENB
-- IC0gRzIwHhcNMTkwNjI1MDAwMDAwWhcNMjAwODA3MjM1OTU5WjCBijELMAkGA1UE
-- BhMCVVMxEzARBgNVBAgMCkNhbGlmb3JuaWExEzARBgNVBAcMClNhbiBSYWZhZWwx
-- FzAVBgNVBAoMDkF1dG9kZXNrLCBJbmMuMR8wHQYDVQQLDBZEZXNpZ24gU29sdXRp
-- b25zIEdyb3VwMRcwFQYDVQQDDA5BdXRvZGVzaywgSW5jLjCCASIwDQYJKoZIhvcN
-- AQEBBQADggEPADCCAQoCggEBAMsptjSEm+HPve6+DClr+K4CgrtrONjtHxHBwTMC
-- mrwF9bnsdMiSgvYigTKk858TlqVs7GiBVLD3SaSZqfSXOv7L55i965L+wIx0EZxX
-- xDzbyLh1rLSSNWO8oTDIKnPsiwo5x7CHRUi/eAICOvLmz7Rzi+becd1j/JPNWe5t
-- vum0GL/8G4vYICrhCycizGIuv3QFqv0YPM75Pd2NP0V4W87XPeTrj+qQoRKMztJ4
-- WNDgLgT4LbMBIZyluU8iwXNyWQ8FC2ya3iJyy0EhZhAB2H7oMrAcV1VJJqwZcZQU
-- XMJTD+tuCqKqJ1ftv1f0JVW2AADnHgvaB6E6Y9yR/jnn4zECAwEAAaOCAT4wggE6
-- MAkGA1UdEwQCMAAwDgYDVR0PAQH/BAQDAgeAMBMGA1UdJQQMMAoGCCsGAQUFBwMD
-- MGEGA1UdIARaMFgwVgYGZ4EMAQQBMEwwIwYIKwYBBQUHAgEWF2h0dHBzOi8vZC5z
-- eW1jYi5jb20vY3BzMCUGCCsGAQUFBwICMBkMF2h0dHBzOi8vZC5zeW1jYi5jb20v
-- cnBhMB8GA1UdIwQYMBaAFNTABiJJ6zlL3ZPiXKG4R3YJcgNYMCsGA1UdHwQkMCIw
-- IKAeoByGGmh0dHA6Ly9yYi5zeW1jYi5jb20vcmIuY3JsMFcGCCsGAQUFBwEBBEsw
-- STAfBggrBgEFBQcwAYYTaHR0cDovL3JiLnN5bWNkLmNvbTAmBggrBgEFBQcwAoYa
-- aHR0cDovL3JiLnN5bWNiLmNvbS9yYi5jcnQwDQYJKoZIhvcNAQELBQADggEBADo7
-- 6cASiVbzkjsADk5MsC3++cj9EjWeiuq+zzKbe55p6jBNphsqLUvMw+Z9r2MpxTEs
-- c//MNUXidFsslWvWAUeOdtytNfhdyXfENX3baBPWHhW1zvbOPHQLyz8LmR1bNe9f
-- R1SLAezJaGzeuaY/Cog32Jh4qDyLSzx87tRUJI2Ro5BLA5+ELiY21SDZ7CP9ptbU
-- CDROdHY5jk/WeNh+3gLHeikJSM9/FPszQwVc9mjbVEW0PSl1cCLYEXu4T0o09ejX
-- NaQPg10POH7FequNcKw50L63feYRStDf6GlO4kNXKFHIy+LPdLaSdCQL2/oi3edV
-- MdpL4F7yw1zQBzShYMoxggHFMIIBwQIBATCBmTCBhDELMAkGA1UEBhMCVVMxHTAb
-- BgNVBAoTFFN5bWFudGVjIENvcnBvcmF0aW9uMR8wHQYDVQQLExZTeW1hbnRlYyBU
-- cnVzdCBOZXR3b3JrMTUwMwYDVQQDEyxTeW1hbnRlYyBDbGFzcyAzIFNIQTI1NiBD
-- b2RlIFNpZ25pbmcgQ0EgLSBHMgIQNQAWQxDGoj0+W1nZ5QbXoTANBgkqhkiG9w0B
-- AQsFADANBgkqhkiG9w0BAQEFAASCAQB9aJj4kBx3cUwXjxgfB3Ri/sYsCcmWRtLM
-- iquJOEDZLas7pjvPlexB6NWwk/6K9FMfmeT8pKHqInkRSNLWgfJOsnkavecBBkZN
-- 3nJl/w0pCGFB/c0y8+wTvam5hcfv8MxiyRu8vmw93f3aijWXwYikAI2o83R8mIl5
-- 6QyIdM4eShg94hrIgPHrGvCB5oFen+8T9VBcZ3Plqeem898MHw3qf4ODT4k0GDeF
-- rT7rffYpZjA8QShsPkQ3kHMb9MlxgE25mY0IIKvrj0jEHBZbzBASggdma4NVyJuM
-- kGYQIHe1f3jGhTOqW43/Giez8BOifUqbOo6lDFVaUnChx6W+hTSm
-- -----END-SIGNATURE-----